package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.util.LinkedHashMap;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Attente d'un vnement slot
 *
 */
public class AttenteEvenementSlot{

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(AttenteEvenementSlot.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param bloque Boolen dterminant s'il l'attente d'vnement doit se faire en mode bloqu
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitementP11(PKCS11 librairie, boolean bloque) throws ExceptionTraitement {

		try {
		
			if(librairie != null) {		
		
				ResultatInfo resultat = new ResultatInfo("Attente d'un vnement slot (C_WaitForSlotEvent)");
				LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();
				resultat.setInfos(infos);
		
				Long slot = null;
				try {
					
					// Traitement  tester
					slot = librairie.C_WaitForSlotEvent(bloque?0L:1L,null);
					
					// Formatage du rsultat
					infos.put("Identifiant du slot sur lequel un vnement est survenu",Long.toString(slot));
					
				} catch (PKCS11Exception e) {
					
					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
		
				if(slot != null) {
					CK_SLOT_INFO info = null;
					try {
						info = librairie.C_GetSlotInfo(slot);
					} catch (PKCS11Exception e) {
						// On ne fait rien, il ne s'agit pas de la fonction que l'on teste dans ce traitement
					}
					
					// On prcise le type d'vnement
					if(info != null) {
						if((info.flags & PKCS11Constants.CKF_TOKEN_PRESENT)!=0)
							resultat.setTraitement(resultat.getTraitement()+" de type Insertion");
						else
							resultat.setTraitement(resultat.getTraitement()+" de type Retrait");
					}
				}
				
				return resultat;
				
				
			} else {
	
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_ATTENTE_EVENEMENT_SLOT, "La librairie est nulle");
				
			}
			
		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_ATTENTE_EVENEMENT_SLOT, "Une erreur inattendue est survenue");
			
		}
	}

}
